//
//	APPI_Plugin.cpp
//


#include <stdio.h>
#include <string.h>
#include <Box.h>
#include <Button.h>
#include <CheckBox.h>
#include <Debug.h>
#include <Message.h>
#include <RadioButton.h>
#include <Roster.h>
#include <ScrollView.h>
#include <TextControl.h>
#include <TextView.h>
#include <View.h>
#include "APPI_Plugin.h"
#include "TypeListView.h"


BRect APPI_Plugin::default_frame(250.0, 250.0, 506.0, 400.0);


#pragma export on

BredPlugin*
new_editor(const char* name, DBlock& databuf)
{
	return new APPI_Plugin(name, databuf);
}

#pragma export reset


APPI_Plugin::APPI_Plugin(const char* name, DBlock& databuf)
	: BredPlugin(default_frame, name, databuf), tlist(NULL), typecnt(0L)
{
}


APPI_Plugin::~APPI_Plugin()
{
}


void
APPI_Plugin::MessageReceived(BMessage* msg)
{
	long	prevcnt;
	
	switch (msg->what) {
	case msg_SetLaunchExclusive:
		flags &= ~B_LAUNCH_MASK;
		flags |=  B_EXCLUSIVE_LAUNCH;
		break;
		
	case msg_SetLaunchSingle:
		flags &= ~B_LAUNCH_MASK;
		flags |=  B_SINGLE_LAUNCH;
		break;
		
	case msg_SetLaunchMultiple:
		flags &= ~B_LAUNCH_MASK;
		flags |=  B_MULTIPLE_LAUNCH;
		break;

#define	ToggleBit(F,M)	if (F & M) {	\
							F &= ~M;	\
						} else {		\
							F |=  M;	\
						}
						
	case msg_ToggleBackground:
		ToggleBit(flags, B_BACKGROUND_APP);
		break;
		
	case msg_ToggleARGVOnly:
		ToggleBit(flags, B_ARGV_ONLY);
		break;

#undef	ToggleBit

	case msg_TypeSelected:
		BButton*	bRem;
		bRem = (BButton*) FindView("Remove");
		bRem->SetEnabled( (tlist->CurrentSelection() >= 0L) );
		break;
	
	case msg_AddType:
		printf("     Adding type...\n");
		BTextView*	typefield = (BTextView*) FindView("newtype");
		ASSERT(typefield != NULL);
		
		if (typefield->TextLength() == 4L) {
			ulong type;
			type = * ((ulong*) typefield->Text()) ;
			
			if (!tlist->HasItem((void*)type)) {
				tlist->AddItem((void*)type);
				prevcnt = typecnt++;
			}
			tlist->Select( tlist->IndexOf((void*)type) );
			
			typefield->SelectAll();
			typefield->Delete();
		}
		break;
		
	case msg_RemoveType:
		long	index = tlist->CurrentSelection();
		(void) tlist->RemoveItem(index);
		tlist->Select(index);
		prevcnt = typecnt--;
		break;
	
	default:
		BWindow::MessageReceived(msg);
		break;
	}
	
	{
	// now set the appropriate fields in the buffer
	switch (msg->what) {
	case msg_SetLaunchExclusive:
	case msg_SetLaunchSingle:
	case msg_SetLaunchMultiple:
	case msg_ToggleBackground:
	case msg_ToggleARGVOnly:
		buffer.Unregister(this);
		buffer(4,4) = DBlock((char*)&flags, 4);
		buffer.Register(this);
		break;
	
	case msg_AddType:
	case msg_RemoveType:
		ASSERT (typecnt = tlist->CountItems());
		ASSERT (typecnt >= 0L);
		
		ulong*	newtypes = new ulong [typecnt + 2];
		newtypes [0] = typecnt;
		for (long i = 0; i < typecnt; ++i) {
			newtypes[i+1] = (ulong) tlist->ItemAt(i);
		}
		newtypes[typecnt+1] = 0L;	// why? who knows???
		
		buffer.Unregister(this);
		buffer(8, 4*(prevcnt+2)) = DBlock((const char*)newtypes, 4*(typecnt+2));
		buffer.Register(this);
				
		delete [] newtypes;
		break;
		
	default:
		break;
	}
	}
}


void
APPI_Plugin::SetupInterface(void)
{
	Lock();
	
//-----------------------------------------------

	BView*			group;
	BRadioButton	*radio1, *radio2, *radio3;

	group = new BView(BRect(4.0, 4.0, 124.0, 52.0), "launch group",
					B_FOLLOW_LEFT | B_FOLLOW_TOP, NULL);
					
	radio1 = new BRadioButton(	BRect(0.0, 0.0, 120.0, 16.0),
								"Exclusive", "Exclusive Launch",
								new BMessage(msg_SetLaunchExclusive)	);
	radio2 = new BRadioButton(	BRect(0.0, 16.0, 120.0, 32.0),
								"Single", "Single Launch",
								new BMessage(msg_SetLaunchSingle)	);
	radio3 = new BRadioButton(	BRect(0.0, 32.0, 120.0, 48.0),
								"Multiple", "Multiple Launch",
								new BMessage(msg_SetLaunchMultiple)	);
	group->AddChild(radio1);	
	group->AddChild(radio2);	
	group->AddChild(radio3);	
	AddChild(group);

//-----------------------------------------------

	BCheckBox		*cbox1, *cbox2;

	cbox1 = new BCheckBox(	BRect(128.0, 4.0, 248.0, 20.0),
							"Background", "Background App",
							new BMessage(msg_ToggleBackground)	);
	cbox2 = new BCheckBox(	BRect(128.0, 20.0, 248.0, 36.0),
							"ARGVOnly", "ARGV Only",
							new BMessage(msg_ToggleARGVOnly)	);
	AddChild(cbox1);
	AddChild(cbox2);

//-----------------------------------------------

	BScrollView		*scroller;

	tlist = new TypeListView(BRect(128.0, 56.0, 232.0, 140.0));
	scroller = new BScrollView("", tlist, B_FOLLOW_ALL_SIDES,
								0, FALSE, TRUE, TRUE);
	AddChild(scroller);

//-----------------------------------------------

	BButton			*bAdd, *bRem;
	BTextView		*typefield;

	bAdd = new BButton(	BRect(4.0, 120.0, 54.0, 140.0),
							"Add", "Add", new BMessage(msg_AddType));
	
	bRem = new BButton(	BRect(64.0, 120.0, 124.0, 140.0),
							"Remove", "Remove", new BMessage(msg_RemoveType));
	
	BBox*	border = new BBox(	BRect(4.0, 90.0, 54.0, 110.0)	);
	typefield = new BTextView(	BRect(1.0, 1.0, 49.0, 19.0),
								"newtype", BRect(1.0, 1.0, 49.0, 0.0),
								B_FOLLOW_LEFT | B_FOLLOW_TOP,
								B_WILL_DRAW | B_FULL_UPDATE_ON_RESIZE | B_NAVIGABLE);
	AddChild(bAdd);
	AddChild(bRem);
	border->AddChild(typefield);
	AddChild(border);
	SetDefaultButton(bAdd);
	typefield->SetMaxChars(4L);
	typefield->SetTabWidth(10.0);
	bRem->SetEnabled(FALSE);		// nothing selected in list when starting 
	
//-----------------------------------------------

	Unlock();
}


void
APPI_Plugin::DataChanged(void)
{
	Lock();

	long		sz, totsz;
	BControl*	cntl;
	const char*	dat;
	
	// first, let's get the size to make sure we can
	// actually read something
	dat = buffer.Data(totsz);

	if (totsz < 16) {
		char	factory[16] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };
		memcpy(factory, dat, totsz);
		totsz = 16;
	
		buffer.Unregister(this);
		buffer = DBlock(factory, totsz);
		buffer.Register(this);
	}

	// for now, i ignore buffer(0,4) , the signature
		
	flags = *((ulong*) buffer(4,4).Data(sz));

	switch (flags & B_LAUNCH_MASK) {
	case B_EXCLUSIVE_LAUNCH:
		cntl = (BControl*) FindView("Exclusive");
		break;

	case B_SINGLE_LAUNCH:
		cntl = (BControl*) FindView("Single");
		break;
		
	case B_MULTIPLE_LAUNCH:
		cntl = (BControl*) FindView("Multiple");
		break;
	}
	cntl->SetValue(B_CONTROL_ON);
	
	cntl = (BControl*) FindView("Background");
	cntl->SetValue(flags & B_BACKGROUND_APP ? B_CONTROL_ON : B_CONTROL_OFF);
	
	cntl = (BControl*) FindView("ARGVOnly");
	cntl->SetValue(flags & B_ARGV_ONLY ? B_CONTROL_ON : B_CONTROL_OFF);

	tlist->MakeEmpty();
	typecnt = * ((ulong*) buffer(8,4).Data(sz));
	for (long index = 0; index < typecnt; ++index) {

		// what if typecnt is too big for the provided data?
		if ((16+4*index) > totsz) {
			typecnt = index;
			break;
		}
		
		ulong	type = * ((ulong*) buffer((12+4*index), 4).Data(sz));

		if (!tlist->HasItem((void*) type)) {
			tlist->AddItem((void*) type);
		}
	}
	
	Unlock();
}
